<?php

namespace Elementor;

if( is_singular( 'page' ) || is_singular( 'ht_dest' ) ):

/* MENU LAYOUT
***************************************************/
$page->add_control( 'page_menu_layout', array(
    'type'    => \Elementor\Controls_Manager::SELECT,
    'label'   => esc_html__( 'Menu layout', 'goto' ),
    'default' => 'default',
    'options' => array(
        'default'  => esc_html__( 'Default', 'goto' ),
        'layout-1' => esc_html__( 'Layout 1', 'goto' ),
        'layout-2' => esc_html__( 'Layout 2', 'goto' ),
        'layout-3' => esc_html__( 'Layout 3', 'goto' ),
    )
)); 


/* PAGE HEADER OPTION
***************************************************/
$page->add_control( 'page_header', array(
    'type'         => \Elementor\Controls_Manager::SWITCHER,
    'label'        => esc_html__( 'Show page header', 'goto' ),
    'default'      => 'yes',
    'label_on'     => esc_html__( 'Yes', 'goto' ),
    'label_off'    => esc_html__( 'No', 'goto' ),
    'return_value' => 'yes',
));

$page->add_control( 'page_header_height', array(
    'type'  => Controls_Manager::SLIDER,
    'label' => esc_html__( 'Page header height', 'goto' ),
    'range' => array(
        'px' => array(
            'min'  => 100,
            'max'  => 1000,
            'step' => 1
        ),
    ),
    'size_units' => array( 'px' ),
    'condition'  => array(
        'page_header' => 'yes'
    ),
));

$page->add_control( 'page_header_space', array(
    'type'  => Controls_Manager::SLIDER,
    'label' => esc_html__( 'Page header space', 'goto' ),
    'range' => array(
        'px' => array(
            'min'  => 0,
            'max'  => 1000,
            'step' => 1
        ),
    ),
    'size_units' => array( 'px' ),
    'condition'  => array(
        'page_header' => 'yes'
    ),
));



/* FOOTER OPTION
***************************************************/
$page->add_control( 'page_footer', array(
    'type'         => \Elementor\Controls_Manager::SWITCHER,
    'label'        => esc_html__( 'Show page footer', 'goto' ),
    'default'      => 'yes',
    'label_on'     => esc_html__( 'Yes', 'goto' ),
    'label_off'    => esc_html__( 'No', 'goto' ),
    'return_value' => 'yes',
));

endif;