<?php

namespace Elementor;

class goto_destination_tax extends Goto_Carousel_Base {
	public function get_name() {
		return 'dest-tax';
	}

	public function get_categories() {
		return array( 'goto-theme' );
	}

	public function get_title() {
		return esc_html__( 'Destination', 'goto' );
	}

	public function get_icon() {
		return 'eicon-check-circle';
	}

	protected function _register_controls() {
		$this->sectionLayout();
		$this->sectionArrows();
		$this->sectionDots();
	}

	private function sectionLayout(){
		$this->start_controls_section( 'd_layout', array(
			'label' => esc_html__( 'Layout', 'goto' ),
		));

		$this->add_control( 'layout', array(
			'type'    => Controls_Manager::SELECT,
			'label'   => esc_html__( 'Layout', 'goto' ),
			'default' => 'list',
			'options' => array(
				'list'     => esc_html__( 'List', 'goto' ),
				'grid'     => esc_html__( 'Grid', 'goto' ),
				'carousel' => esc_html__( 'Carousel', 'goto' ),
			),
		));

		$this->add_control( 'list_inline', array(
			'type'    => Controls_Manager::SELECT,
			'label'   => esc_html__( 'Display', 'goto' ),
			'default' => 'inherit',
			'options' => array(
				'inherit' => esc_html__( 'Inherit', 'goto' ),
				'inline-block'  => esc_html__( 'Inline', 'goto' ),
			),
			'condition' => array(
				'layout' => 'list'
			),
			'selectors' => array(
				'{{WRAPPER}} .wdd-item' => 'display: {{VALUE}};'
			),
		));

		$this->add_control( 'list_inline_space', array(
			'type' => Controls_Manager::SLIDER,
			'label' => esc_html__( 'Space', 'goto' ),
			'default' => array(
				'size' => 30
			),
			'range' => array(
				'px' => array(
					'min' => 1,
					'max' => 100,
					'step' => 1
				),
			),
			'size_units' => array( 'px' ),
			'condition' => array(
				'layout' => 'list',
				'layout.list_inline' => 'inline'
			),
			'selectors' => array(
				'{{WRAPPER}} .wdd-item' => 'margin-right: {{SIZE}}{{UNIT}};'
			),
		));

		$this->add_control( 'list_color', array(
			'type'      => Controls_Manager::COLOR,
			'label'     => esc_html__( 'Color', 'goto' ),
			'default'   => '',
			'condition' => array(
				'layout' => 'list'
			),
			'selectors' => array(
				'{{WRAPPER}} .wdd-item a' => 'color: {{VALUE}};'
			),
		));

		$this->add_control( 'list_hover_color', array(
			'type'      => Controls_Manager::COLOR,
			'label'     => esc_html__( 'Hover color', 'goto' ),
			'default'   => '',
			'condition' => array(
				'layout' => 'list'
			),
			'selectors' => array(
				'{{WRAPPER}} .wdd-item a:hover' => 'color: {{VALUE}};'
			),
		));

		$this->add_control( 'arrows', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Arrows', 'goto' ),
			'default'      => 'yes',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'carousel'
			)
		));

		$this->add_control( 'dots', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Dots', 'goto' ),
			'default'      => '',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'carousel'
			)
		));

		$this->add_responsive_control( 'col', array(
			'type'           => Controls_Manager::SELECT,
			'label'          => esc_html__( 'Column', 'goto' ),
			'default'        => 3,
			'tablet_default' => 2,
			'mobile_default' => 1,
			'options'        => array(
				1 => 1,
				2 => 2,
				3 => 3,
				4 => 4,
				5 => 5,
			),
			'condition' => array(
				'layout!' => 'list'
			)
		));

		$this->add_control( 'data', array(
			'type'     => Controls_Manager::SELECT2,
			'label'    => esc_html__( 'Enter destinations', 'goto' ),
			'multiple' => true,
			'options'  => goto_get_narrow_data( 'dest' ),
		));

		$this->add_control( 'per_page', array(
			'type'    => Controls_Manager::NUMBER,
			'label'   => esc_html__( 'Posts Per Page', 'goto' ),
			'default' => 6,
			'min'     => -1,
			'max'     => 100,
		));

		$this->add_control( 'orderby', array(
			'type' => Controls_Manager::SELECT,
			'label' => esc_html__( 'Order By', 'goto' ),
			'default' => 'date',
			'options' => array(
				'date' => esc_html__( 'Date', 'goto' ),
				'title' => esc_html__( 'Title', 'goto' ),
				'ID' => esc_html__( 'ID', 'goto' ),
				'author' => esc_html__( 'Author', 'goto' ),
				'modified' => esc_html__( 'Modified', 'goto' ),
			),
		));

		$this->add_control( 'order', array(
			'type' => Controls_Manager::SELECT,
			'label' => esc_html__( 'Order', 'goto' ),
			'default' => 'DESC',
			'options' => array(
				'ASC' => esc_html__( 'ASC', 'goto' ),
				'DESC' => esc_html__( 'DESC', 'goto' ),
			),
		));

		$this->add_control( 'd_grid_pagi', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Pagination', 'goto' ),
			'default'      => '',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'grid'
			)
		));

		$this->add_responsive_control( 'list_align', array(
			'type'    => Controls_Manager::CHOOSE,
			'label'   => esc_html__( 'Alignment', 'goto' ),
			'options' => array(
				'left' => array(
					'title' => esc_html__( 'Left', 'goto' ),
					'icon'  => 'fa fa-align-left'
				),
				'center' => array(
					'title' => esc_html__( 'Center', 'goto' ),
					'icon'  => 'fa fa-align-center'
				),
				'right' => array(
					'title' => esc_html__( 'Right', 'goto' ),
					'icon'  => 'fa fa-align-right'
				),
			),
			'default'        => 'left',
			'tablet_default' => 'left',
			'mobile_default' => 'left',
			'selectors'      => array(
				'{{WRAPPER}} .wd-dest-content' => 'text-align: {{VALUE}};'
			),
			'condition' => array(
				'layout' => 'list'
			),
		));

		$this->add_responsive_control( 'd_grid_pagi_align', array(
			'type'    => Controls_Manager::CHOOSE,
			'label'   => esc_html__( 'Alignment', 'goto' ),
			'options' => array(
				'left' => array(
					'title' => esc_html__( 'Left', 'goto' ),
					'icon'  => 'fa fa-align-left'
				),
				'center' => array(
					'title' => esc_html__( 'Center', 'goto' ),
					'icon'  => 'fa fa-align-center'
				),
				'right' => array(
					'title' => esc_html__( 'Right', 'goto' ),
					'icon'  => 'fa fa-align-right'
				),
			),
			'default'        => 'left',
			'tablet_default' => 'left',
			'mobile_default' => 'left',
			'selectors'      => array(
				'{{WRAPPER}} .ht-pagination' => 'text-align: {{VALUE}};'
			),
			'condition' => array(
				'layout'             => 'grid',
				'layout.d_grid_pagi' => 'yes'
			),
		));

		$this->add_responsive_control( 'd_pagi_space', array(
			'type' => Controls_Manager::DIMENSIONS,
			'label' => esc_html__( 'Space', 'goto' ),
			'size_units' => array( 'px', 'em' ),
			'default' => array(
				'top'      => '30',
				'right'    => '0',
				'bottom'   => '0',
				'left'     => '0',
				'unit'     => 'px',
				'isLinked' => false,
			),
			'tablet_default' => array(
				'top'      => '20',
				'right'    => '0',
				'bottom'   => '20',
				'left'     => '0',
				'unit'     => 'px',
				'isLinked' => false,
			),
			'mobile_default' => array(
				'top'      => '15',
				'right'    => '0',
				'bottom'   => '15',
				'left'     => '0',
				'unit'     => 'px',
				'isLinked' => false,
			),
			'condition' => array(
				'layout'             => 'grid',
				'layout.d_grid_pagi' => 'yes'
			),
			'selectors' => array(
				'{{WRAPPER}} .ht-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			),
		));

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$paged = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
		$dest_args = array(
			'post_type'           => 'ht_dest',
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'posts_per_page'      => $settings['per_page'],
			'orderby'             => $settings['orderby'],
			'order'               => $settings['order'],
			'paged'               => $paged,
		);
		
		if( ! empty( $settings['data'] ) ){
			$dest_args['post__in'] = $settings['data'];
		}

		$dest_q = new \WP_Query( $dest_args );

		/*GENERATE UNIQI ID*/
		$tiny_slider_id = uniqid( 'wd-dest-id-' );
		
		/*RENDER CAROUSEL*/
		$this->renderCarousel( $tiny_slider_id, $settings['layout'], $settings['col'], $settings['col_tablet'], $settings['col_mobile'] );

		/*GENERATE CAROUSEL OPTIONS*/
		$tiny_slider_data = $this->carouselOptions( $settings['layout'], $settings['col'], $settings['col_tablet'], $settings['col_mobile'] );

		/*CLASSES*/
		$classes = 'wd-dest-layout-'. $settings['layout'] .' ht-grid ht-grid-'. $settings['col'] .' ht-grid-tablet-'. $settings['col_tablet'] .' ht-grid-mobile-'. $settings['col_mobile'];

		/*ADD `not-real-class` FOR SLIDER ANIMATION*/
		$layout_name = 'carousel' == $settings['layout'] ? 'not-real-slider' : '';

		?>
		<div class="wd-dest">
			<div class="<?php echo esc_attr( $classes ); ?>">
				<div class="wd-dest-content <?php echo esc_attr( $layout_name ); ?>" id="<?php echo esc_attr( $tiny_slider_id ); ?>" <?php echo wp_kses_post( $tiny_slider_data ); ?>>
					<?php
						$unit =  function_exists( 'fw_get_db_ext_settings_option' ) ? goto_unit( fw_get_db_ext_settings_option( 'tour', 'unit' ) ) : '&#36;';
						while( $dest_q->have_posts() ):
							$dest_q->the_post();
							$dest_count = function_exists( 'fw_get_db_post_option' ) ? count( fw_get_db_post_option( get_the_ID(), 'tour_id' ) ) : 0;

							/*LIST LAYOUT*/
							if( 'list' == $settings['layout'] ){
								?>
									<h4 class="wdd-item" <?php goto_schema_markup( 'creative_work' ); ?>>
										<a href="<?php the_permalink(); ?>" itemprop="headline"><?php the_title(); ?><span class="wdt-count">(<?php echo esc_html( $dest_count ); ?>)</span></a>
									</h4>
								<?php
							}else{
								$img_id     = get_post_thumbnail_id( get_the_ID() );
								$img_alt    = goto_img_alt( $img_id, esc_attr__( 'Tour list image', 'goto' ) );
								$img_src    = ! empty( $img_id ) ? get_the_post_thumbnail_url( get_the_ID(), 'medium_large' ) : get_template_directory_uri() . '/images/tour/370x240.png';
							?>
								<div class="ht-grid-item" <?php goto_schema_markup( 'creative_work' ); ?>>
									<div class="wdd-item">
										<a class="wdd-head" href="<?php the_permalink(); ?>"></a>
										<img class="wdd-img" src="<?php echo esc_attr( $img_src ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
										<div class="wdd-cont">
											<h3 class="wddc-name entry-title" itemprop="headline"><?php the_title(); ?></h3>
											<span class="wddc-count">
												<?php
													$_tour_label = 0 == $dest_count || $dest_count > 1 ? __( 'Tours', 'goto' ) : __( 'Tour', 'goto' );
													echo esc_html( $dest_count . ' ' . $_tour_label );
												?>
											</span>
											<div class="wddc-desc" itemprop="text"><?php the_excerpt(); ?></div>
										</div>
									</div>
								</div>
							<?php
							}
						endwhile;

						/*PAGINATION TAXONOMY FOR GRID LAYOUT*/
						if( 'grid' == $settings['layout'] && 'yes' == $settings['d_grid_pagi'] && empty( $settings['data'] ) ):
							goto_paging( $dest_q );
						endif;

						wp_reset_postdata();
						?>
				</div>
			</div>
		</div>
	<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new goto_destination_tax() );