<?php

if ( post_password_required() || function_exists( 'fw_ext_feedback_stars_get_post_rating()' ) ) return;

$rating = fw_ext_feedback_stars_get_post_rating();
$count = $rating['count'];

$total = round( $rating['average'], 2 ) . esc_html__( ' Average', 'goto' );

$detail_rating = fw_ext_feedback_stars_get_post_detailed_rating( get_queried_object_id() );

$_5 = $detail_rating['stars'][5]['as_percentage'];
$_4 = $detail_rating['stars'][4]['as_percentage'];
$_3 = $detail_rating['stars'][3]['as_percentage'];
$_2 = $detail_rating['stars'][2]['as_percentage'];
$_1 = $detail_rating['stars'][1]['as_percentage'];

$section_title = is_singular( 'post' ) ? '' : 'tour-section-title';
?>

<div id="comments" class="comments-area review-content">
	<?php if ( have_comments() ): ?>
		<h5 class="comments-title <?php echo esc_attr( $section_title ); ?>">
            <?php
                if( $count > 0 && is_singular( 'ht_tour' ) ){
                    echo sprintf( _nx( 'Review ( 1 )', 'Reviews ( %s )', $count, 'review count', 'goto' ), $count );
                }else{
                    echo sprintf( _nx( 'Comment ( 1 )', 'Comments ( %s )', get_comments_number(), 'comment count', 'goto' ), get_comments_number() );
                }
            ?>
        </h5>

        <?php if( $count > 0 ): ?>
            <dl id="reviews-detail" class="tmp_cls">
               <dt><?php esc_html_e( 'Excellent', 'goto' ); ?></dt>
               <dd>
                    <span class="rating-stars rating-stars-5"></span>
                    <div class="stars-bar">
                        <span class="star-progress"><span style="width: <?php echo esc_attr( $_5 ); ?>%"></span></span>
                        <span class="star-label"><?php echo esc_html( round( $_5 ) ) . '%'; ?></span>
                    </div>
               </dd>
               <dt><?php esc_html_e( 'Good', 'goto' ); ?></dt>
               <dd>
                   <span class="rating-stars rating-stars-4"></span>
                   <div class="stars-bar">
                        <span class="star-progress"><span style="width: <?php echo esc_attr( $_4 ); ?>%"></span></span>
                        <span class="star-label"><?php echo esc_html( round( $_4 ) ) . '%'; ?></span>
                   </div>
               </dd>
               <dt><?php esc_html_e( 'Average', 'goto' ); ?></dt>
               <dd>
                   <span class="rating-stars rating-stars-3"></span>
                   <div class="stars-bar">
                        <span class="star-progress"><span style="width: <?php echo esc_attr( $_3 ); ?>%"></span></span>
                        <span class="star-label"><?php echo esc_html( round( $_3 ) ) . '%'; ?></span>
                   </div>
               </dd>
               <dt><?php esc_html_e( 'Rather Poor', 'goto' ); ?></dt>
               <dd>
                   <span class="rating-stars rating-stars-2"></span>
                   <div class="stars-bar">
                        <span class="star-progress"><span style="width: <?php echo esc_attr( $_2 ); ?>%"></span></span>
                        <span class="star-label"><?php echo esc_html( round( $_2 ) ) . '%'; ?></span>
                   </div>
               </dd>
               <dt><?php esc_html_e( 'Bad', 'goto' ); ?></dt>
               <dd>
                   <span class="rating-stars rating-stars-1"></span>
                   <div class="stars-bar">
                        <span class="star-progress"><span style="width: <?php echo esc_attr( $_1 ); ?>%"></span></span>
                        <span class="star-label"><?php echo esc_html( round( $_1 ) ) . '%'; ?></span>
                   </div>
               </dd>
            </dl>
        <?php endif; ?>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ): /*comment navigation*/ ?>
            <nav id="comment-nav-above" class="navigation comment-navigation" role="navigation">
                <h2 class="screen-reader-text"><?php esc_html_e( 'Review navigation', 'goto' ); ?></h2>
                <div class="cmt-previous"><?php previous_comments_link( esc_html__( 'Older Reviews', 'goto' )); ?></div>
                <div class="cmt-next"><?php next_comments_link( esc_html__( 'Newer Reviews ', 'goto' )); ?></div>
            </nav>
        <?php endif; ?>

		<ul class="comment-list">
			<?php
    			wp_list_comments( array(
                    'walker'     => fw_ext_feedback_get_listing_walker(),
                    'style'      => 'ul',
                    'short_ping' => true,
                    'format'     => 'html5'
    			) );
			?>
		</ul>

		<?php if ( ! comments_open() ): ?>
			<p class="no-comments"><?php esc_html_e( 'Reviews are closed.', 'goto' ); ?></p>
		<?php endif; ?>

	<?php endif;?>

	<?php
        $fields = array(
            'email' =>
                '<div class="cmt-field cmt-input"><label>'. sprintf( esc_html__( 'E-mail%s', 'goto' ), '<sup class="must-tag">*</sup>' ) .'</label><input id="email" type="email" name="email" value="' . esc_attr(  $commenter['comment_author_email'] )  . '" required></div>',
            'author' =>
                '<div class="cmt-field cmt-input"><label>'. sprintf( esc_html__( 'Name%s', 'goto' ), '<sup class="must-tag">*</sup>' ) .'</label><input id="author" type="text" name="author" value="' . esc_attr( $commenter['comment_author'] ).'" required></div>'
        );

        $args = array(
            'title_reply_before' => '<h5 id="reply-title" class="comment-reply-title">',
            'title_reply' => esc_html__( 'Write a Review', 'goto'),
            'title_reply_after' => '</h5>',
            'fields' => apply_filters( 'comment_form_default_fields', $fields ),
            'comment_field' => '<div class="cmt-field cmt-textarea"><label>'. sprintf( esc_html__( 'Your review%s', 'goto' ), '<sup class="must-tag">*</sup>' ) .'</label><textarea id="comment" name="comment" required>' . '</textarea></div>',
            'label_submit' => esc_html__( 'Submit your review', 'goto'),
        );

        comment_form( $args );
    ?>
</div>

<?php

if( $count > 0 ):
    wp_add_inline_script(
        'goto-custom-script',
        "document.elementInViewport = function ( el ) {
            var viewport = {},
                bounds = {};

            viewport.top = window.pageYOffset;
            viewport.bottom = viewport.top + window.innerHeight;
            bounds.top = el.getBoundingClientRect().top + window.pageYOffset;
            bounds.bottom = bounds.top + el.clientHeight;

            return ( bounds.bottom >= viewport.top && bounds.bottom <= viewport.bottom ) || ( bounds.top <= viewport.bottom && bounds.top >= viewport.top );
        }

        document.addEventListener( 'DOMContentLoaded', function () {
            function reviewSkin(){
                var reviewElement = document.getElementById( 'reviews-detail' );

                if( ! reviewElement ) return;

                if( document.elementInViewport( reviewElement ) )
                    reviewElement.classList.remove( 'tmp_cls' );
            }

            window.addEventListener( 'load', function(){
                reviewSkin();
            } );
            window.addEventListener( 'scroll', function(){
                reviewSkin();
            } );
        } );",
        'after'
    );
endif;