<?php


/* ADD SINGLE TOUR SECTION
***************************************************/
Goto_Kirki::add_section( 'single_tour', array(
    'title'      => esc_attr__( 'Single Tour', 'goto' ),
    'priority'   => 1,
));


/*MENU LAYOUT*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'radio-buttonset',
    'settings'    => 'tour_menu_layout_cfg',
    'label'       => esc_attr__( 'Menu Layout', 'goto' ),
    'section'     => 'single_tour',
    'default'     => 'layout-1',
    'description' => esc_attr__( 'Choose Menu Preset Select your main header preset here to apply for Tour single', 'goto' ),
    'choices'     => array(
        'layout-1' => esc_attr__( 'Menu 1', 'goto' ),
        'layout-2' => esc_attr__( 'Menu 2', 'goto' ),
        'layout-3' => esc_attr__( 'Menu 3', 'goto' ),
    ),
    'partial_refresh' => array(
        'single_tour_menu_layout' => array(
            'selector'        => '.single-ht_tour #theme-menu-layout',
            'render_callback' => 'goto_menu_layout',
        ),
    ),
));

/*HEADER LAYOUT*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'radio-buttonset',
    'settings'    => 'tour_header_layout_cfg',
    'label'       => esc_attr__( 'Header Layout', 'goto' ),
    'section'     => 'single_tour',
    'default'     => 'tour-1',
    'description' => esc_attr__( 'Choose Header layout apply for Tour single', 'goto' ),
    'choices'     => array(
        'tour-1' => esc_attr__( 'Header 1', 'goto' ),
        'tour-2' => esc_attr__( 'Header 2', 'goto' ),
        'tour-3' => esc_attr__( 'Header 3', 'goto' ),
    ),
));

/*content background*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'color',
    'label'     => esc_attr__( 'Background content', 'goto' ),
    'settings'  => 'single_tour_bg',
    'section'   => 'single_tour',
    'default'   => '#f6f6f6',
    'transport' => 'auto',
    'output'    => array(
        array(
            'element'  => '.single-ht_tour #main',
            'property' => 'background-color'
        )
    ),
));

/*support*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'editor',
    'label'     => esc_attr__( 'Custumer support', 'goto' ),
    'settings'  => 'support',
    'section'   => 'single_tour',
    'transport' => 'postMessage',
    'js_vars'   => array(
        array(
            'element'  => '.tour-custumer-support',
            'function' => 'html',
        ),
    ),
));

/*related tour*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'text',
    'label'       => esc_attr__( 'Related tours', 'goto' ),
    'settings'    => 'tour_related',
    'section'     => 'single_tour',
    'default'     => 3,
    'description' => esc_attr__( 'Enter "-1" to show all related tours or "0" to disable related tours', 'goto' )
));

/*related column*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'select',
    'label'       => esc_attr__( 'Related tours columns', 'goto' ),
    'settings'    => 'tour_related_col',
    'section'     => 'single_tour',
    'default'     => 3,
    'choices'     => array(
        2 => 2,
        3 => 3,
        4 => 4,
    ),
));

/*related carousel*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'switch',
    'label'       => esc_attr__( 'Related tours carousel?', 'goto' ),
    'settings'    => 'tour_related_carousel',
    'section'     => 'single_tour',
    'default'     => false,
    'choices'     => array(
        'off' => esc_attr__( 'No', 'goto' ),
        'on'  => esc_attr__( 'Yes', 'goto' ),
    )
));