<?php

if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class goto_Widget_Flickr extends WP_Widget {

    /**
     * @internal
     */
    function __construct() {
        $widget_ops = array( 'description' => esc_html__( 'Display your Flickr latest photostream in widget', 'goto' ) );
        parent::__construct( false, esc_html__( 'Flickr', 'goto' ), $widget_ops );
    }

    /**
     * @param array $args
     * @param array $instance
     */
    function widget( $args, $instance ) {
        extract( $args );

        $flickr_id = $instance['flickr_id'];
        $size      = $instance['size'];
        $col       = $instance['col'];
        $number    = (int) $instance['number'];
        $title     = $before_title . $instance['title'] . $after_title;
        
        $filepath = get_template_directory().'/inc/widgets/flickr/views/widget.php';
        if ( file_exists( $filepath ) ) {
            include( $filepath );
        }
    }

    function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title']     = ! empty( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : esc_html__( 'Flickr', 'goto' );
        $instance['flickr_id'] = ! empty( $new_instance['flickr_id'] ) ? sanitize_text_field( $new_instance['flickr_id'] ) : '';
        $instance['size']      = ! empty( $new_instance['size'] ) ? $new_instance['size'] : 'large_square';
        $instance['col']       = ! empty( $new_instance['col'] ) ? $new_instance['col'] : 2;
        $instance['number']    = ! empty( $new_instance['number'] ) ? absint( $new_instance['number'] ) : 6;

        return $instance;
    }

    function form( $instance ) {
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'goto' ); ?></label>
            <input type="text" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   value="<?php echo esc_attr( $instance['title'] ); ?>" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"/>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'flickr_id' ) ); ?>"><?php esc_html_e( 'Flickr ID', 'goto' ); ?> (<a
                    href="http://www.idgettr.com" target="_blank">idGettr</a>):</label>
            <input type="text" name="<?php echo esc_attr( $this->get_field_name( 'flickr_id' ) ); ?>"
                   value="<?php echo esc_attr( $instance['flickr_id'] ); ?>" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'flickr_id' ) ); ?>"/>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'size' ) ); ?>"><?php esc_html_e( 'Image size', 'goto' ); ?></label>
            <select name="<?php echo esc_attr( $this->get_field_name( 'size' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'size' ) ); ?>" class="widefat" value="<?php echo esc_attr( $instance['size'] ); ?>">
               <option value="small" <?php echo 'small' == $instance['size'] ? 'selected' : ''; ?>><?php esc_html_e( 'Small', 'goto' ); ?></option>
               <option value="square" <?php echo 'square' == $instance['size'] ? 'selected' : ''; ?>><?php esc_html_e( 'Square', 'goto' ); ?></option>
               <option value="large_square" <?php echo 'large_square' == $instance['size'] ? 'selected' : ''; ?>><?php esc_html_e( 'Large square', 'goto' ); ?></option>
               <option value="thumbnail" <?php echo 'thumbnail' == $instance['size'] ? 'selected' : ''; ?>><?php esc_html_e( 'Thumbnail', 'goto' ); ?></option>
               <option value="medium" <?php echo 'medium' == $instance['size'] ? 'selected' : ''; ?>><?php esc_html_e( 'Medium', 'goto' ); ?></option>
               <option value="large" <?php echo 'large' == $instance['size'] ? 'selected' : ''; ?>><?php esc_html_e( 'Large', 'goto' ); ?></option>
               <option value="full" <?php echo 'full' == $instance['size'] ? 'selected' : ''; ?>><?php esc_html_e( 'Large', 'goto' ); ?></option>
           </select>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'col' ) ); ?>"><?php esc_html_e( 'Column', 'goto' ); ?></label>
            <select name="<?php echo esc_attr( $this->get_field_name( 'col' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'col' ) ); ?>" class="widefat" value="<?php echo esc_attr( $instance['col'] ); ?>">
               <option value="1" <?php echo 1 == $instance['col'] ? 'selected' : ''; ?>>1</option>
               <option value="2" <?php echo 2 == $instance['col'] ? 'selected' : ''; ?>>2</option>
               <option value="3" <?php echo 3 == $instance['col'] ? 'selected' : ''; ?>>3</option>
               <option value="4" <?php echo 4 == $instance['col'] ? 'selected' : ''; ?>>4</option>
               <option value="5" <?php echo 5 == $instance['col'] ? 'selected' : ''; ?>>5</option>
           </select>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of photos', 'goto' ); ?>
                :</label>
            <input type="text" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>"
                   value="<?php echo esc_attr( $instance['number'] ); ?>" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"/>
        </p>
    <?php
    }
}