<?php

/* ADD COLOR SECTION
***************************************************/
Goto_Kirki::add_section( 'color', array(
	'title'      => esc_attr__( 'Colors', 'goto' ),
	'priority'   => 1,
));



/* PRIMARY COLOR
***************************************************/
Goto_Kirki::add_field( 'goto', array(
	'type'      => 'color',
	'label'     => esc_attr__( 'Primary color', 'goto' ),
	'settings'  => 'primary_color',
	'section'   => 'color',
	'default'   => '#ec5849',
	'transport' => 'auto',
	'output'    => array(
		/*! COLOR
		------------------------------------------------->*/
		array(
			'element' => array(
				'a:hover',
				'.content-wrap .blog-read-more',
				'.comment-info a',
				'.form-submit input[type="submit"]:hover',
				'.footer-subscribe-form button:hover',
				'.wpcf7-form input[type="submit"]:hover',
				'.tour-price span',
				'.tour-table-info .editor-icon-untick',
				'#clear-all-key',
				'.wd-dest-layout-grid .wdd-item:hover .wddc-name',
				'.wd-dest-layout-carousel .wdd-item:hover .wddc-name',
				'.elementor-shortcode .wpcf7 form input.wpcf7-submit:hover',
				'.back-to-home:hover',
				'.bl-read-more',
				'.tour-acc-head.active',
				'.tour-navbox a.active',
				'.tour-navbox a:hover',
			),
			'property' => 'color'
		),

		/*! BACKGROUND
		------------------------------------------------->*/
		array(
			'element' => array(
				'.page-numbers.current',
				'.cover-image time',
				'.comment-info a:hover',
				'.form-submit input[type="submit"]',
				'.footer-subscribe-form button',
				'.tour-section-title:before',
				'.tour-acc-item:first-of-type:after',
				'.tour-acc-item:last-of-type:after',
				'.wpcf7-form input[type="submit"]',
				'.trh-price-box',
				'.tli-price',
				'.place-search-spn button',
				'.wd-tours-layout-carousel .wdt-percent-sale',
				'.wd-tours-layout-carousel .wdt-url-btn:hover',
				'.wd-dest-layout-grid .wddc-price',
				'.wd-dest-layout-carousel .wddc-price',
				'.elementor-shortcode .wpcf7 form input.wpcf7-submit',
				'.back-to-home',
				'.wd-blog-list .bl-date',
				'.theme-menu-label',
				'.landing-btn',
			),
			'property' => 'background-color'
		),

		/*! BORDER
		------------------------------------------------->*/
		array(
			'element' => array(
				'.comment-info a',
				'.form-submit input[type="submit"]',
				'.widget_tag_cloud a:hover',
				'.footer-subscribe-form button',
				'.wpcf7-form input[type="submit"]',
				'.wd-tours-layout-carousel .wdt-url-btn',
				'.elementor-shortcode .wpcf7 form input.wpcf7-submit',
				'.back-to-home',
				'.tagcloud a:hover:before',
				'#preloader:before'
			),
			'property' => 'border-color'
		),

		array(
			'element' => array(
				'.tour-navbox a.active',
			),
			'property' => 'border-bottom-color'
		),

		array(
			'element' => array(
				'blockquote'
			),
			'property' => 'border-left-color'
		)
	)
));

/* SECONDARY COLOR
***************************************************/
Goto_Kirki::add_field( 'goto', array(
	'type'      => 'color',
	'label'     => esc_attr__( 'Primary color', 'goto' ),
	'settings'  => 'second_color',
	'section'   => 'color',
	'default'   => '#03ab96',
	'transport' => 'auto',
	'output'    => array(
		/*! COLOR
		------------------------------------------------->*/
		array(
			'element' => array(
				'.rating-stars:before',
				'.tour-desc-icon',
				'.rating .fa.fa-star.voted',
				'.wrap-rating.in-post .rating:hover .fa.fa-star.over',
				'.tour-contactform-tick span',
				'.tour-table-info .editor-icon-tick',
				'.tl-view-btn.active',
				'.tour-view-list .tlc-cat:before'
			),
			'property' => 'color'
		),

		/*! BACKGROUND
		------------------------------------------------->*/
		array(
			'element' => array(
				'.tour-average',
				'.tour-acc-item:not(:first-of-type):not(:last-of-type):after',
				'.tl-sidebar-title',
				'.dp:before, .dp-days a:hover, .dp-days a.dp-current, .dp-selected',
				'.tl-sidebar-block .slider-fill',
				'.wdp-sticky',
				'.single-tour-2 .tour-lightbox-btn',
				'#tl-topbar:before'
			),
			'property' => 'background-color'
		),

		/*! BORDER
		------------------------------------------------->*/
		array(
			'element' => array(
				'.tl-view-btn.active',
				'.dp-days .dp-day-today'
			),
			'property' => 'border-color'
		),

		array(
			'element' => array(
				'.tour-right-sidebar .tour-price-box',
				'.tour-price-box .tour-sale-rate:after'
			),
			'property' => 'border-top-color'
		)
	)
));