<div class="blog-article" <?php goto_schema_markup( 'blog' ); ?>>
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php goto_schema_markup( 'blog_list' ); ?>>
        <div itemprop="mainEntityOfPage">
            <?php goto_post_format(); ?>
            <div class="content-wrap">
                <header class="entry-header">
                    <?php
                        if ( is_single() ):
                            the_title( '<h1 class="entry-title screen-reader-text">', '</h1>' );
                        else :
                            the_title( '<h2 class="entry-title blog-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                        endif;
                    ?>
                </header>
                <ul class="entry-meta goto_post_info">
                    <?php goto_post_info(); ?>
                </ul>
                <div class="entry-summary"><?php goto_seo_data(); ?></div>
                <div class="entry-content" <?php goto_schema_markup( 'post_content' ); ?>>
                    <?php
                        if( is_single() ) {
                            the_content();
                            goto_wp_link_pages();
                        }else{
                            the_excerpt();
                        }
                    ?>
                </div>
                <footer class="entry-footer">
                    <?php
                        if( is_single() ):
                            goto_blog_tags();
                        else:
                    ?>
                        <a href="<?php the_permalink(); ?>" class="blog-read-more"><?php esc_html_e( 'Read More +', 'goto' ); ?><span class="screen-reader-text"><?php esc_html_e( 'about an interesting article to read', 'goto' ) ?></span></a>
                    <?php endif; ?>
                </footer>
            </div>
        </div>
    </article>
</div>