<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class ServiceOwnerController extends Controller
{
    public function index()
    {
        $serviceOwners = User::where('role', 'service_owner')->get();
        return view('service_owners.index', compact('serviceOwners'));
    }

    public function create()
    {
        return view('service_owners.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'phone' => 'required|string|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
        ]);

        User::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'password' => Hash::make($request->password),
            'role' => 'service_owner',
        ]);

        return redirect()->route('service_owners.index')->with('success', 'Service Owner created successfully.');
    }

    public function edit($id)
    {
        $serviceOwner = User::findOrFail($id);
        return view('service_owners.edit', compact('serviceOwner'));
    }

    public function update(Request $request, $id)
    {
        $serviceOwner = User::findOrFail($id);

        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users,email,'.$serviceOwner->id,
            'phone' => 'required|string|max:255|unique:users,phone,'.$serviceOwner->id,
            'password' => 'nullable|string|min:8|confirmed',
        ]);

        $serviceOwner->update([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'password' => $request->password ? Hash::make($request->password) : $serviceOwner->password,
        ]);

        return redirect()->route('service_owners.index')->with('success', 'Service Owner updated successfully.');
    }

    public function destroy($id)
    {
        $serviceOwner = User::findOrFail($id);
        $serviceOwner->delete();

        return redirect()->route('service_owners.index')->with('success', 'Service Owner deleted successfully.');
    }
}
