<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Ticket;
use App\Models\IncomingRequest;
use Illuminate\Support\Facades\Http;

class WhatsAppController extends Controller
{
    public function webhook(Request $request)
    {
        // Store the raw request body
        $requestBody = $request->getContent();
        IncomingRequest::create(['request_body' => $requestBody]);

        // Decode the JSON request
        $data = json_decode($requestBody, true);

        // Extract information from the request body
        $chat_id = $data['chat_id'];
        $first_name = $data['first_name'];
        $user_input_data = $data['user_input_data'];

        $issue_type = "";
        $start_date = "";
        $details = "";

        foreach ($user_input_data as $input) {
            if ($input['question'] == "What type of issue are you facing?") {
                $issue_type = $input['answer'];
            } elseif ($input['question'] == "When did it start?") {
                $start_date = $input['answer'];
            } elseif ($input['question'] == "Please provide more details about the issue:") {
                $details = $input['answer'];
            }
        }

        $serviceOwner = User::where('role', 'service_owner')
                            ->where('service', $data['user_input_data'][0]['answer'])
                            ->first();

        // Check if user exists, else create a new user
        $user = User::firstOrCreate(
            ['phone' => $chat_id],
            ['name' => $first_name, 'email' => null, 'password' => bcrypt('password')]]
        );

        // Create a new ticket
        $ticket = Ticket::create([
            'title' => "Issue: $issue_type",
            'description' => "Start date: $start_date\nDetails: $details",
            'user_id' => $user->id,
            'status' => 'New'
        ]);

        // Send ticket number and created date back to the user via WhatsApp
        $this->sendWhatsAppNotification(
            $data['chat_id'],
            $ticket->id,
            $ticket->created_at->format('Y-m-d H:i:s'),
            '83888'
        );

        if ($serviceOwner) {
            // Notify the service owner
            $this->notifyServiceOwner($ticket);
        }

        return response()->json(['status' => 'success'], 200);

    }

    private function sendWhatsAppNotification($phoneNumber, $ticketNumber, $createdDate, $templateId)
    {
        $apiToken = '4969|RhZtToATIqzYkPwVqmlSqL7k6QuaUxmbnF3axFAE';

        Http::post('https://dash.botbiz.io/api/v1/whatsapp/send/template', [
            'apiToken' => $apiToken,
            'phoneNumberID' => '354530977737384',
            'botTemplateID' => $templateId,
            'templateVariable-ticketno-2' => $ticketNumber,
            'templateVariable-system-delivery-date-3' => $createdDate
        ]);
    }

    private function notifyServiceOwner(Ticket $ticket)
    {
        $apiToken = '4969|RhZtToATIqzYkPwVqmlSqL7k6QuaUxmbnF3axFAE';
        $serviceOwner = $ticket->service_owner;

        Http::post('https://dash.botbiz.io/api/v1/whatsapp/send/template', [
            'apiToken' => $apiToken,
            'phoneNumberID' => '354530977737384',
            'botTemplateID' => '83976',
            'templateVariable-assignedTo-1' => $serviceOwner->name,
            'templateVariable-ticketOwner-2' => $ticket->user->name,
            'templateVariable-ticketDetails-3' => $ticket->description,
            'templateVariable-ticketno-4' => $ticket->id,
            'templateVariable-ticketOwner-5' => $ticket->user->name,
            'templateVariable-ticketOwnerPhone-6' => $ticket->user->phone,
            'sendToPhoneNumber' => $serviceOwner->phone
        ]);
    }
}
