<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ticket extends Model
{
    use HasFactory;

    protected $fillable = [
        'title', 'description', 'user_id', 'service_owner_id', 'status'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function service_owner()
    {
        return $this->belongsTo(User::class, 'service_owner_id');
    }
}
