<x-guest-layout>
    <main class="login-form">

        <div class="cotainer w-full sm:max-w-md mt-6 px-6 py-4 bg-white shadow-md overflow-hidden sm:rounded-lg">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">Login</div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('login') }}">
                                @csrf

                                <!-- Phone -->
                                <div class="form-group row">
                                    <x-label for="phone" class="col-md-4 col-form-label text-md-right"
                                        :value="__('Phone')" />

                                    <x-input id="phone" class=" col-md-8 block mt-1 w-full form-control" type="text"
                                        name="phone" :value="old('phone')" required autofocus />
                                </div>

                                <!-- Password -->
                                <div class="mt-4 form-group row">
                                    <x-label for="password" class="col-md-4 col-form-label text-md-right"
                                        :value="__('Password')" />

                                    <x-input id="password" class=" col-md-8 form-control block mt-1 w-full" type="password"
                                        name="password" required autocomplete="current-password" />
                                </div>

                                <div class="form-group row">
                                    <div class="col-md-6 offset-md-4">
                                        <div class="checkbox">
                                            <label>
                                                <input id="remember_me" type="checkbox"
                                                    class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"
                                                    name="remember">
                                                <span class="ml-2 text-sm text-gray-600">{{ __('Remember me') }}</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 offset-md-4 flex items-center justify-end mt-4">

                                    <x-button class="ml-3 btn btn-primary">
                                        {{ __('Log in') }}
                                    </x-button>

                                    @if (Route::has('password.request'))
                                        <a class="underline text-sm text-gray-600 hover:text-gray-900 btn btn-link"
                                            href="{{ route('password.request') }}">
                                            {{ __('Forgot your password?') }}
                                        </a>
                                    @endif
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </main>
</x-guest-layout>
