
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Service Owners') }}
        </h2>
    </x-slot>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Service Owners') }}</div>

                <div class="card-body">
                    <a href="{{ route('service_owners.create') }}" class="btn btn-primary mb-3">{{ __('Add Service Owner') }}</a>

                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>{{ __('Name') }}</th>
                                <th>{{ __('Email') }}</th>
                                <th>{{ __('Phone') }}</th>
                                <th>{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($serviceOwners as $serviceOwner)
                                <tr>
                                    <td>{{ $serviceOwner->name }}</td>
                                    <td>{{ $serviceOwner->email }}</td>
                                    <td>{{ $serviceOwner->phone }}</td>
                                    <td>
                                        <a href="{{ route('service_owners.edit', $serviceOwner->id) }}" class="btn btn-warning">{{ __('Edit') }}</a>
                                        <form action="{{ route('service_owners.destroy', $serviceOwner->id) }}" method="POST" style="display:inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger">{{ __('Delete') }}</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</x-app-layout>
