<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\ServiceOwnerController;
use App\Http\Controllers\WhatsAppController;
use App\Http\Controllers\TicketController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

require __DIR__.'/auth.php';

Route::resource('service_owners', ServiceOwnerController::class)->middleware('auth');
Route::resource('tickets', TicketController::class)->middleware('auth');

Route::post('/whatsapp/webhook', [WhatsAppController::class, 'webhook']);
